#include "stdafx.h"
#include "ContentList.h"
#include "tools.h"
#include "connhand.h"
#include "resource.h"
#include "fsdindexerdlg.h"

ContentList cl;
wstring datapath;

ContentList::ContentList(void)
{
}

ContentList::~ContentList(void)
{
}


void ContentList::SaveContentList()
{
	FILE * fp = NULL;
	ch.WriteFile(&fp,datapath + L"content.xml");
	//fopen_s(&fp,string(datapath + "content.xml").c_str(),"w");
	if (fp == NULL)
	{
		return;
	}

	vector<ContentItem*>::iterator itr;

	wstring temp = L"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
	temp.reserve(500000);

	temp.append(L"<freestyle>\n");

	sub1ProgMax = Content.size();
	sub1ProgCur = 0;

	for (itr = Content.begin() ; itr != Content.end() ; itr++)
	{
		sub1ProgCur++;

		temp.append(sprintfa(L"\t<game type='%d'>\n",(*itr)->type));
		temp.append(sprintfa(L"\t\t<id>%s</id>\n",(*itr)->id.c_str()));
		temp.append(sprintfa(L"\t\t<title>%s</title>\n",(*itr)->title.c_str()));
		temp.append(sprintfa(L"\t\t<path>%s</path>\n",(*itr)->path.c_str()));
		temp.append(sprintfa(L"\t\t<desc>%s</desc>\n",(*itr)->desc.c_str()));
		temp.append(sprintfa(L"\t\t<imgpath>%s</imgpath>\n",(*itr)->imagefolder.c_str()));
		temp.append(sprintfa(L"\t\t<images sscount='%d' icon='%d' boxart='%d' background='%d' />\n",(*itr)->i_SSCount,(int)(*itr)->i_Icon,(int)(*itr)->i_BoxArt,(int)(*itr)->i_Background));
		temp.append(sprintfa(L"\t\t<mediaid>%d</mediaid>\n",(*itr)->mediaid.c_str()));
		temp.append(sprintfa(L"\t\t<manufacturer>%s</manufacturer>\n",(*itr)->manuf.c_str()));
		temp.append(sprintfa(L"\t\t<disks no='%d' count='%d' />\n",(*itr)->discno,(*itr)->disccn));
		temp.append(sprintfa(L"\t\t<version>%d</version>\n",(*itr)->version));
		if ((*itr)->c_type >=6)
		{
			temp.append(sprintfa(L"\t\t<custom c_type='%d' />\n",(*itr)->type));
		} else {
			temp.append(sprintfa(L"\t\t<custom c_type='%d' />\n",(*itr)->c_type));
		}
		temp.append(L"\t\t<genres>\n");

		vector<wstring>::iterator gi;
		for (gi = (*itr)->genres.begin() ; gi != (*itr)->genres.end() ; gi++)
		{
			temp.append(sprintfa(L"\t\t\t<genre>%s</genre>\n",(*gi).c_str()));
		}

		temp.append(L"\t\t</genres>\n");
		temp.append(L"\t</game>\n");
	}
	temp.append(L"</freestyle>\n");

	int neededbuffer = WideCharToMultiByte(CP_UTF8,0,temp.c_str(),-1,NULL,0,NULL,FALSE);
	if (neededbuffer == 0)
	{
		ch.CloseFile(fp);
		return;
	}
	char* buf2 = new char[neededbuffer];
	memset(buf2,0,neededbuffer);
	int res = WideCharToMultiByte(CP_UTF8,0,temp.c_str(),-1,buf2,neededbuffer,NULL,FALSE);
	if (res == 0)
	{
		ch.CloseFile(fp);
		return;
	}

	fwrite(buf2,1,neededbuffer,fp);

	delete buf2;

	ch.CloseFile(fp);
	//fclose(fp);
}

void ContentList::LoadContentXML()
{
	XMLReader * xml = ch.LoadConfigFile(datapath + L"content.xml");

	Content.clear();
	PathLookup.clear();
	Genres.clear();
	Paths.clear();

	while (xml && xml->read())
	{
		if (StartAttribute(xml,L"game"))
		{
			ContentItem * item = new ContentItem();
			item->type = xml->getAttributeValueAsInt(L"type");
			while (!EndAttribute(xml,L"game"))
			{
				if (StartAttribute(xml,L"title"))
				{
					item->title = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"path"))
				{
					item->path = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"id"))
				{
					item->id = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"desc"))
				{
					item->desc = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"imgpath"))
				{
					item->imagefolder = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"genre"))
				{
					item->genres.push_back(xml->getSubNodeData());
				}
				if (StartAttribute(xml,L"manufacturer"))
				{
					item->manuf = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"mediaid"))
				{
					item->mediaid = xml->getSubNodeData();
				}
				if (StartAttribute(xml,L"version"))
				{
					item->version = _wtoi(xml->getSubNodeData().c_str());
				}
				if (StartAttribute(xml,L"disks"))
				{
					item->discno = xml->getAttributeValueAsInt(L"no");
					item->disccn = xml->getAttributeValueAsInt(L"count");
				}
				if (StartAttribute(xml,L"images"))
				{
					item->i_SSCount = xml->getAttributeValueAsInt(L"sscount");
					item->i_Icon = xml->getAttributeValueAsBool(L"icon");
					item->i_BoxArt = xml->getAttributeValueAsBool(L"boxart");
					item->i_Background = xml->getAttributeValueAsBool(L"background");
				}
				if (StartAttribute(xml,L"custom"))
				{
					item->c_type = xml->getAttributeValueAsInt(L"c_type");
				}
			}
			MakeShortPath(item);
			Content.push_back(item);
		}
	}

	FreeXMLAndText(xml);

	LoadAltInfo();
}

void ContentList::MakeShortPath(ContentItem * item)
{
	wstring folder = item->path.substr(0,item->path.rfind(L"\\"));
	if (item->type == 0)
	{
		folder = item->id;
	}
	folder = make_lowercase(folder);
	item->shortpath = folder;
	PathLookup[folder] = item;
}

bool SortContent(const ContentItem * left, const ContentItem * right) 
{ 
	int res = _wcsicmp(left->title.c_str(),right->title.c_str());
	if (res < 0) return true;
	return false;
}

bool SortGenres(const GenreItem * left, const GenreItem * right) 
{ 
	int res = _wcsicmp(left->title.c_str(),right->title.c_str());
	if (res < 0) return true;
	return false;
}

void ContentList::SortAll()
{
	sort(Content.begin(), Content.end(),SortContent);
	for (int i = 0 ; i < 6 ; i++)
	{
		vector<GenreItem*> * l = Genres[i];
		sort(l->begin(), l->end(),SortGenres);
	}
}

void ContentList::BuildGenreList()
{
	for (int i = 0 ; i < 6 ; i++)
	{
		vector <GenreItem*> * l = new vector <GenreItem*>;
		Genres[i] = l;
	}

	vector <ContentItem*>::iterator itr;
	for (itr = Content.begin() ; itr != Content.end() ; itr++)
	{
		ContentItem * item = (*itr);
		vector <wstring>::iterator gi;

		vector <GenreItem*> * l = Genres[item->type];

		for (gi = item->genres.begin() ; gi != item->genres.end() ; gi++)
		{
			wstring genre = (*gi);
			
			bool found = false;
			vector <GenreItem*>::iterator fi;
			for (fi = l->begin() ; fi != l->end() ; fi++)
			{
				GenreItem* git = (*fi);
				if (git->title == genre)
				{
					found = true;
					break;
				}
			}

			if (!found)
			{
				GenreItem* item = new GenreItem();
				item->title = genre;
				l->push_back(item);
			}		
		}
	}
}

ContentItems* ContentList::GetItems(bool OnlyIncomplete, int Type)
{
	ContentItems * result = new ContentItems();
	//result.pItems = new ContentItem[Content.size()];
	vector <ContentItem*>::iterator itr;

	memset(result->pItems,0,1000);
	int count = 0;

	for (itr = Content.begin() ; itr != Content.end() ; itr++)
	{
		ContentItem * item = (*itr);

		if (OnlyIncomplete && item->CheckComplete())
			continue;

		if (Type > -1)
		{
			if (Type != item->type)
				continue;
		}

		result->pItems[count] = item;
		count++;
	}
	result->nItems = count;

	//DebugMsg("ContentList::GetItems(%d,%s,%d) returning %d items",type,wstrtostr(genre).c_str(),OnlyFavs,count);
	return result;
}

void ContentList::LoadAltInfo()
{
	XMLReader * xml = LoadConfigFile(L"altcontent.xml");
	while (xml && xml->read())
	{
		if (StartAttribute(xml,L"game"))
		{
			AltInfo * ai = new AltInfo();
			wstring titleid = make_lowercase(xml->getAttributeValue(L"id"));
			int version = xml->getAttributeValueAsInt(L"version");
			ai->Version = version;
			AltInfos[titleid] = ai;
			while (!EndAttribute(xml,L"game"))
			{
				if (StartAttribute(xml,L"alturl"))
					ai->AltUrl = xml->getSubNodeData();
				if (StartAttribute(xml,L"title"))
					ai->Title = xml->getSubNodeData();
				if (StartAttribute(xml,L"desc"))
					ai->Desc = xml->getSubNodeData();
				if (StartAttribute(xml,L"manuf"))
					ai->Manuf = xml->getSubNodeData();
				if (StartAttribute(xml,L"boxart"))
					ai->BoxArt = xml->getSubNodeData();
				if (StartAttribute(xml,L"background"))
					ai->Background = xml->getSubNodeData();
				if (StartAttribute(xml,L"sslink"))
					ai->Screenshots.push_back(xml->getSubNodeData());
				if (StartAttribute(xml,L"genre"))
					ai->Genres.push_back(xml->getSubNodeData());
			}
		}
	}
	FreeXMLAndText(xml);
}